package com.iit;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

/**
 * Servlet implementation class ListUsersServlet
 */
public class ListUsersServlet extends HttpServlet {
	private static final long serialVersionUID = 1L;

	/**
	 * @see HttpServlet#HttpServlet()
	 */
	public ListUsersServlet() {
		super();
	}

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		response.setCharacterEncoding("utf-8");
		
		LogicController controller = new LogicController();
		ArrayList<User> users = controller.ListUsers();
		
		PrintWriter out = response.getWriter();
		out.println("<html><body><table><tr><th>Database id</th><th>First name</th><th>Last name</th><th>Create Date</th></tr>");
		for (int i = 0; i < users.size(); i++) {
			out.println("<tr>");
			out.println("<td>" + users.get(i).getRow_id() + "</td>");
			out.println("<td>" + users.get(i).getFirstname() + "</td>");
			out.println("<td>" + users.get(i).getLastname() + "</td>");
			out.println("<td>" + users.get(i).getCreatedate() + "</td>");
			out.println("</tr>");
		}
		out.println("</body></html>");
	}
}
