package com.iit;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Random;

import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.handshake.ServerHandshake;
import org.json.JSONObject;

/**
 * Test Client
 * 
 * @author voxel
 *
 */
public class WebsocketClient extends WebSocketClient {

	public WebsocketClient(URI serverUri, Draft draft) {
		super(serverUri, draft);
	}

	public WebsocketClient(URI serverURI) {
		super(serverURI);
	}

	public static void main(String[] args) throws URISyntaxException {
		WebSocketClient client = new WebsocketClient(new URI("ws://localhost:8888"));

		client.connect();
	}

	/**
	 * Make a simple request on websocket
	 * 
	 * @return
	 */
	public String makeMessage() {

		int randomID = new Random().nextInt();
		
		JSONObject rootObj = new JSONObject();
		rootObj.put("id", randomID);
		rootObj.put("nick", "Bela");
		rootObj.put("type", "message");
		rootObj.put("text", "Hi, I am a tester3!");
		rootObj.put("ts", 1784564524);

		return rootObj.toString();
	}

	@Override
	public void onOpen(ServerHandshake handshakedata) {
		System.out.println("Websocket is connected...");

		String message = makeMessage();

		System.out.println("Sending to server: " + message);
		send(message);
	}

	@Override
	public void onClose(int code, String reason, boolean remote) {
		System.out.println("closed with exit code " + code + " additional info: " + reason);
	}

	@Override
	public void onMessage(String message) {
		System.out.println("received message: " + message);
	}

	@Override
	public void onMessage(ByteBuffer message) {
		System.out.println("received ByteBuffer");
	}

	@Override
	public void onError(Exception ex) {
		System.err.println("an error occurred:" + ex);
	}

}
