package com.iit;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

/**
 * Websocket server
 * 
 * @author voxel
 *
 */
public class MyWebSocketServer extends WebSocketServer {

	static int port = 8888;
	static String url = "localhost";

	public MyWebSocketServer() {
		super(new InetSocketAddress(url, port));
	}

	@Override
	public void onOpen(WebSocket conn, ClientHandshake handshake) {
		System.out.println("New connection to " + conn.getRemoteSocketAddress());
	}

	@Override
	public void onClose(WebSocket conn, int code, String reason, boolean remote) {
		System.out.println(
				"closed " + conn.getRemoteSocketAddress() + " with exit code " + code + " additional info: " + reason);
	}

	@Override
	public void onMessage(WebSocket conn, String message) {
		System.out.println("Received message from " + conn.getRemoteSocketAddress() + ": " + message);

		// JSONObject rootObj = new JSONObject(message);

		// String valami = rootObj.getString("input");
		broadcast(message);

	}

	@Override
	public void onMessage(WebSocket conn, ByteBuffer message) {
		System.out.println("Received ByteBuffer from " + conn.getRemoteSocketAddress());
	}

	@Override
	public void onError(WebSocket conn, Exception ex) {
		System.err.println("An error occurred on connection " + conn.getRemoteSocketAddress() + ":" + ex);
	}

	@Override
	public void onStart() {
		System.out.println("Server started successfully at port: " + port);
	}
}