import { Component, OnInit } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { AuthService } from '../auth.service';

@Component({
  selector: 'app-protected',
  template: '<h3>Protected</h3><div *ngIf="msg">{{msg}}</div><button (click)="logout()">Logout</button>'
})
export class ProtectedComponent implements OnInit {
  msg = '';

  constructor(private http: HttpClient, private auth: AuthService) {}

  ngOnInit() {
    const token = this.auth.getToken();
    const headers = new HttpHeaders({ Authorization: 'Bearer ' + token });
    this.http.get<any>('http://localhost:8080/api/auth/hello', { headers }).subscribe({
      next: (res) => this.msg = 'Server response: ' + JSON.stringify(res),
      error: (err) => this.msg = 'Error: ' + JSON.stringify(err)
    });
  }

  logout() {
    this.auth.logout();
  }
}
