package com.example.demo;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.security.Key;

@RestController
@CrossOrigin(origins = "http://localhost:4200") // engedélyezzük az Angular portot
@RequestMapping("/api/auth")
public class AuthController {

    private static final Key key = Keys.hmacShaKeyFor("ReplaceThisWithASecureRandomSecretKeyOfAtLeast32Bytes".getBytes());

    @PostMapping("/login")
    public ResponseEntity<?> login(@RequestBody Map<String, String> body) {
        String username = body.get("username");
        String password = body.get("password");

        if ("user".equals(username) && "password".equals(password)) {
            String token = Jwts.builder()
                .setSubject(username)
                .setIssuedAt(new Date())
                .setExpiration(new Date(System.currentTimeMillis() + 1000L * 60 * 60 * 24))
                .signWith(key, SignatureAlgorithm.HS256)
                .compact();
            Map<String,String> resp = new HashMap<>();
            resp.put("token", token);
            return ResponseEntity.ok(resp);
        } else {
            return ResponseEntity.status(401).body(Map.of("error","Invalid credentials"));
        }
    }

    @GetMapping("/hello")
    public ResponseEntity<?> hello(@RequestHeader(name="Authorization", required=false) String auth) {
        return ResponseEntity.ok(Map.of("msg","Public endpoint OK", "authorization", auth));
    }
}
