/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.json;

import com.google.gson.Gson;
import io.javalin.http.InternalServerErrorResponse;
import io.javalin.json.JsonMapper;
import io.javalin.json.PipedStreamExecutor;
import io.javalin.util.ConcurrencyUtilKt;
import io.javalin.util.CoreDependency;
import io.javalin.util.DependencyUtil;
import io.javalin.util.JavalinLogger;
import io.javalin.util.Util;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J'\u0010\r\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J'\u0010\u0015\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\u001c\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/javalin/json/JavalinGson;", "Lio/javalin/json/JsonMapper;", "gson", "Lcom/google/gson/Gson;", "useVirtualThreads", "", "(Lcom/google/gson/Gson;Z)V", "pipedStreamExecutor", "Lio/javalin/json/PipedStreamExecutor;", "getPipedStreamExecutor", "()Lio/javalin/json/PipedStreamExecutor;", "pipedStreamExecutor$delegate", "Lkotlin/Lazy;", "fromJsonStream", "T", "", "json", "Ljava/io/InputStream;", "targetType", "Ljava/lang/reflect/Type;", "(Ljava/io/InputStream;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "fromJsonString", "", "(Ljava/lang/String;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "toJsonStream", "obj", "type", "toJsonString", "writeToOutputStream", "", "stream", "Ljava/util/stream/Stream;", "outputStream", "Ljava/io/OutputStream;", "javalin"})
public class JavalinGson
implements JsonMapper {
    @NotNull
    private final Gson gson;
    private final boolean useVirtualThreads;
    @NotNull
    private final Lazy pipedStreamExecutor$delegate;

    public JavalinGson(@NotNull Gson gson, boolean useVirtualThreads) {
        Intrinsics.checkNotNullParameter(gson, "gson");
        this.gson = gson;
        this.useVirtualThreads = useVirtualThreads;
        this.pipedStreamExecutor$delegate = ConcurrencyUtilKt.javalinLazy$default(null, new Function0<PipedStreamExecutor>(this){
            final /* synthetic */ JavalinGson this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PipedStreamExecutor invoke() {
                return new PipedStreamExecutor(JavalinGson.access$getUseVirtualThreads$p(this.this$0));
            }
        }, 1, null);
        if (!Util.INSTANCE.classExists(CoreDependency.GSON.getTestClass())) {
            String message = StringsKt.trimMargin$default("|It looks like you don't have Gson dependency on classpath.\n                   |The easiest way to fix this is to simply add the '" + CoreDependency.GSON.getArtifactId() + "' dependency:\n                   |\n                   |" + DependencyUtil.INSTANCE.mavenAndGradleSnippets(CoreDependency.GSON) + "\n                   |", null, 1, null);
            JavalinLogger.warn$default(DependencyUtil.INSTANCE.wrapInSeparators(message), null, 2, null);
            throw new InternalServerErrorResponse(message, null, 2, null);
        }
    }

    public /* synthetic */ JavalinGson(Gson gson, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            gson = new Gson();
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(gson, bl);
    }

    private final PipedStreamExecutor getPipedStreamExecutor() {
        Lazy lazy = this.pipedStreamExecutor$delegate;
        return (PipedStreamExecutor)lazy.getValue();
    }

    @Override
    @NotNull
    public String toJsonString(@NotNull Object obj, @NotNull Type type) {
        String string;
        Intrinsics.checkNotNullParameter(obj, "obj");
        Intrinsics.checkNotNullParameter(type, "type");
        if (obj instanceof String) {
            string = (String)obj;
        } else {
            String string2 = this.gson.toJson(obj, type);
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "toJson(...)");
        }
        return string;
    }

    @Override
    @NotNull
    public InputStream toJsonStream(@NotNull Object obj, @NotNull Type type) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter(obj, "obj");
        Intrinsics.checkNotNullParameter(type, "type");
        if (obj instanceof String) {
            String string = (String)obj;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            inputStream = new ByteArrayInputStream(byArray);
        } else {
            inputStream = this.getPipedStreamExecutor().getInputStream((Function1<? super PipedOutputStream, Unit>)new Function1<PipedOutputStream, Unit>(this, obj, type){
                final /* synthetic */ JavalinGson this$0;
                final /* synthetic */ Object $obj;
                final /* synthetic */ Type $type;
                {
                    this.this$0 = $receiver;
                    this.$obj = $obj;
                    this.$type = $type;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull PipedOutputStream pipedOutputStream) {
                    Intrinsics.checkNotNullParameter(pipedOutputStream, "pipedOutputStream");
                    Closeable closeable = new BufferedWriter(new OutputStreamWriter(pipedOutputStream));
                    JavalinGson javalinGson = this.this$0;
                    Object object = this.$obj;
                    Type type = this.$type;
                    Throwable throwable = null;
                    try {
                        BufferedWriter bufferedWriter = (BufferedWriter)closeable;
                        boolean bl = false;
                        JavalinGson.access$getGson$p(javalinGson).toJson(object, type, (Appendable)bufferedWriter);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                }
            });
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToOutputStream(@NotNull Stream<?> stream, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(outputStream, "outputStream");
        Closeable closeable = new BufferedWriter(new OutputStreamWriter(outputStream));
        Throwable throwable = null;
        try {
            BufferedWriter bufferedWriter = (BufferedWriter)closeable;
            boolean bl = false;
            Ref.BooleanRef hasComma = new Ref.BooleanRef();
            bufferedWriter.write("[");
            stream.forEach(arg_0 -> JavalinGson.writeToOutputStream$lambda$1$lambda$0(hasComma, bufferedWriter, this, arg_0));
            bufferedWriter.write("]");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @Override
    @NotNull
    public <T> T fromJsonString(@NotNull String json, @NotNull Type targetType) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(targetType, "targetType");
        Object object = this.gson.fromJson(json, targetType);
        Intrinsics.checkNotNullExpressionValue(object, "fromJson(...)");
        return (T)object;
    }

    @Override
    @NotNull
    public <T> T fromJsonStream(@NotNull InputStream json, @NotNull Type targetType) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(targetType, "targetType");
        Object object = this.gson.fromJson((Reader)new InputStreamReader(json), targetType);
        Intrinsics.checkNotNullExpressionValue(object, "fromJson(...)");
        return (T)object;
    }

    private static final void writeToOutputStream$lambda$1$lambda$0(Ref.BooleanRef $hasComma, BufferedWriter $bufferedWriter, JavalinGson this$0, Object it) {
        Intrinsics.checkNotNullParameter($hasComma, "$hasComma");
        Intrinsics.checkNotNullParameter($bufferedWriter, "$bufferedWriter");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if ($hasComma.element) {
            $bufferedWriter.write(",");
        } else {
            $hasComma.element = true;
        }
        this$0.gson.toJson(it, (Appendable)$bufferedWriter);
    }

    public JavalinGson() {
        this(null, false, 3, null);
    }

    public static final /* synthetic */ Gson access$getGson$p(JavalinGson $this) {
        return $this.gson;
    }

    public static final /* synthetic */ boolean access$getUseVirtualThreads$p(JavalinGson $this) {
        return $this.useVirtualThreads;
    }
}

