var builder = WebApplication.CreateBuilder(args);

var  MyAllowSpecificOrigins = "_myAllowSpecificOrigins";
builder.Services.AddCors(options =>
{
    options.AddPolicy(name: MyAllowSpecificOrigins,
                      policy  => {
                          policy.WithOrigins("*");
                      });
});

var app = builder.Build();
app.UseCors(MyAllowSpecificOrigins);

// Test: http://localhost:5197/log?rows=10
app.MapGet("/login", (string username, string password) => {

     Console.WriteLine("Login request...");
    LoginResponse res = new LoginResponse("SUCCESS", username+password);
    return res;
});

app.MapGet("/", () => "Hello World!");

app.Run();


class LoginResponse
{
public string status { get; set; }
public string merged { get; set; }

 public LoginResponse(string _status, string _merged)
   {
      status = _status;
      merged = _merged;
   }
}