package com.example.calc;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import jakarta.validation.Valid;

@RestController
@RequestMapping("/api/calc")
@CrossOrigin(origins = "http://localhost:3000") // engedély a React fejlesztő szervernek
public class CalculationController {

	private final CalculationService service;

	public CalculationController(CalculationService service) {
		this.service = service;
	}

	@PostMapping("/calculate")
	public ResponseEntity<CalculationResult> calculate(@Valid @RequestBody CalculationRequest req) {
		try {
			double res = service.calculate(req.getA(), req.getB(), req.getOp());
			return ResponseEntity.ok(new CalculationResult(res));
		} catch (IllegalArgumentException ex) {
			return ResponseEntity.badRequest().body(new CalculationResult(ex.getMessage()));
		} catch (Exception ex) {
			return ResponseEntity.status(500).body(new CalculationResult("Internal error"));
		}
	}
}
