package com.example.calc;

import org.springframework.stereotype.Service;

@Service
public class CalculationService {

    public double calculate(double a, double b, String op) {
        switch (op.toLowerCase()) {
            case "add": return a + b;
            case "sub": return a - b;
            case "mul": return a * b;
            case "div":
                if (b == 0.0) throw new IllegalArgumentException("Division by zero");
                return a / b;
            default: throw new IllegalArgumentException("Unknown operation: " + op);
        }
    }
}

