import React, { useState } from "react";
import { calculate } from "./api";

function App() {
  const [a, setA] = useState("");
  const [b, setB] = useState("");
  const [op, setOp] = useState("add");
  const [result, setResult] = useState(null);
  const [error, setError] = useState(null);

  const onSubmit = async (e) => {
    e.preventDefault();
    setError(null);
    setResult(null);

    const payload = { a: parseFloat(a), b: parseFloat(b), op };

    try {
      const res = await calculate(payload);
      if (res.error) setError(res.error);
      else setResult(res.result);
    } catch (ex) {
      setError("Hálózati hiba vagy backend nem elérhető.");
    }
  };

  return (
    <div style={{ maxWidth: 420, margin: "40px auto", fontFamily: "Arial, sans-serif" }}>
      <h1>Kalkulátor Demo</h1>
      <form onSubmit={onSubmit}>
        <div>
          <input value={a} onChange={e => setA(e.target.value)} placeholder="A érték" required />
        </div>
        <div style={{ marginTop: 8 }}>
          <input value={b} onChange={e => setB(e.target.value)} placeholder="B érték" required />
        </div>
        <div style={{ marginTop: 8 }}>
          <select value={op} onChange={e => setOp(e.target.value)}>
            <option value="add">Összeadás (+)</option>
            <option value="sub">Kivonás (-)</option>
            <option value="mul">Szorzás (×)</option>
            <option value="div">Osztás (÷)</option>
          </select>
        </div>
        <div style={{ marginTop: 12 }}>
          <button type="submit">Számol</button>
        </div>
      </form>

      <div style={{ marginTop: 20 }}>
        {error && <div style={{ color: "crimson" }}>Hiba: {error}</div>}
        {result !== null && <div>Eredmény: <strong>{result}</strong></div>}
      </div>
    </div>
  );
}

export default App;
