
package com.example.demo.controller;

import com.example.demo.entity.Student;
import com.example.demo.service.StudentService;
import org.springframework.web.bind.annotation.*;
import java.util.List;

@RestController
@RequestMapping("/students")
@CrossOrigin(origins = "http://localhost:3000")
public class StudentController {

    private final StudentService service;

    public StudentController(StudentService service) {
        this.service = service;
    }

    @PostMapping
    public Student create(@RequestBody Student student) { return service.create(student); }

    @GetMapping("/{id}")
    public Student get(@PathVariable Long id) { return service.get(id); }

    @GetMapping
    public List<Student> all() { return service.getAll(); }

    @DeleteMapping("/{id}")
    public void delete(@PathVariable("id") Long id) { service.delete(id); }
}
