package com.example.demo.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.example.demo.dao.StudentDAO;
import com.example.demo.entity.Student;

@Service
public class StudentService {

	private final StudentDAO dao;

	public StudentService(StudentDAO dao) {
		this.dao = dao;
	}

	@Transactional
	public Student create(Student student) {
		return dao.save(student);
	}

	@Transactional(readOnly = true)
	public Student get(Long id) {
		return dao.findById(id);
	}

	@Transactional(readOnly = true)
	public List<Student> getAll() {
		return dao.findAll();
	}

	@Transactional
	public void delete(Long id) {
		dao.delete(id);
	}
}
