import React, { useEffect, useState } from "react";
import { getStudents, createStudent, deleteStudent } from "./api";
import StudentList from "./components/StudentList";
import StudentForm from "./components/StudentForm";

function App() {
    const [students, setStudents] = useState([]);

    useEffect(() => {
        loadData();
    }, []);

    const loadData = async () => {
        setStudents(await getStudents());
    };

    const handleAddStudent = async (student) => {
        await createStudent(student);
        loadData();
    };

    const handleDeleteStudent = async (id) => {
        await deleteStudent(id);
        loadData();
    };

    return (
        <div style={{ maxWidth: "600px", margin: "auto", paddingTop: "40px" }}>
            <h1>Student Management</h1>
            <StudentForm onAdd={handleAddStudent} />
            <StudentList students={students} onDelete={handleDeleteStudent} />
        </div>
    );
}

export default App;