import React, { useState } from "react";

function StudentForm({ onAdd }) {
    const [name, setName] = useState("");
    const [age, setAge] = useState("");

    const handleSubmit = (e) => {
        e.preventDefault();
        onAdd({ name, age: parseInt(age) });
        setName("");
        setAge("");
    };

    return (
        <form onSubmit={handleSubmit} style={{ marginBottom: "20px" }}>
            <h2>Add Student</h2>
            <input
                type="text"
                placeholder="Name"
                value={name}
                onChange={(e) => setName(e.target.value)}
                required
            />
            <input
                type="number"
                placeholder="Age"
                value={age}
                onChange={(e) => setAge(e.target.value)}
                required
                style={{ marginLeft: "10px" }}
            />
            <button type="submit" style={{ marginLeft: "10px" }}>
                Add
            </button>
        </form>
    );
}

export default StudentForm;