import React from "react";

function StudentList({ students, onDelete }) {
    return (
        <div>
            <h2>Students</h2>
            <ul>
                {students.map((s) => (
                    <li key={s.id}>
                        {s.name} – {s.age} years old
                        <button 
                            style={{ marginLeft: "10px" }} 
                            onClick={() => onDelete(s.id)}
                        >
                            Delete
                        </button>
                    </li>
                ))}
            </ul>
        </div>
    );
}

export default StudentList;