package http_header;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;


/**
 * Servlet implementation class DisplayHeader
 */
@WebServlet("/DisplayHeader")
public class DisplayHeader extends HttpServlet {
	private static final long serialVersionUID = 1L;

    /**
     * Default constructor. 
     */
    public DisplayHeader() {
        // TODO Auto-generated constructor stub
    }

 // Method to handle GET method request.
    public void doGet(HttpServletRequest request, HttpServletResponse response)
       throws ServletException, IOException {
       
       // Set response content type
       response.setContentType("text/html");
  
       PrintWriter out = response.getWriter();
       String title = "HTTP Header Request Example";
       String docType =
          "<!doctype html public \"-//w3c//dtd html 4.0 " + "transitional//en\">\n";

       out.println(docType +
          "<html>\n" +
          "<head><title>" + title + "</title></head>\n"+
          "<body bgcolor = \"#f0f0f0\">\n" +
          "<h1 align = \"center\">" + title + "</h1>\n" +
          "<table width = \"100%\" border = \"1\" align = \"center\">\n" +
          "<tr bgcolor = \"#949494\">\n" +
          "<th>Header Name</th><th>Header Value(s)</th>\n"+
          "</tr>\n"
       );
  
       Enumeration headerNames = request.getHeaderNames();
     
       while(headerNames.hasMoreElements()) {
          String paramName = (String)headerNames.nextElement();
          out.print("<tr><td>" + paramName + "</td>\n");
          String paramValue = request.getHeader(paramName);
          out.println("<td> " + paramValue + "</td></tr>\n");
       }
       out.println("</table>\n</body></html>");
    }
    
    // Method to handle POST method request.
    public void doPost(HttpServletRequest request, HttpServletResponse response)
       throws ServletException, IOException {

       doGet(request, response);
    }

}
