package connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;

public class CreateConnection {

	// Database URL, username, and password
	static final String DB_URL = "jdbc:mysql://localhost:3306/hello_world";
	static final String USER = "root";
	static final String PASS = "root";

	public static void main(String[] args) {
		Connection conn = null;

		try {
			// Step 1: Register JDBC driver (optional for newer JDBC versions)
			Class.forName("com.mysql.cj.jdbc.Driver");

			// Step 2: Open a connection
			System.out.println("Connecting to the database...");
			conn = DriverManager.getConnection(DB_URL, USER, PASS);

			System.out.println("Connected to the database!");

		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			// Finally block to close resources
			try {
				if (conn != null)
					conn.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

}
