package user_servlet;

import java.io.IOException;
import java.io.PrintWriter;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import model.User;

/**
 * Servlet implementation class UserServlet
 */
@WebServlet("/UserServlet")
public class UserServlet extends HttpServlet {
	private static final long serialVersionUID = 1L;
	private static final String DB_URL = "jdbc:mysql://localhost:3306/user_management";
	private static final String DB_USER = "root";
	private static final String DB_PASSWORD = "root";

	private ArrayList<User> userList;

	/**
	 * Default constructor.
	 */
	public UserServlet() {
		this.userList = new ArrayList<User>();
	}
	
	
	public void initDBDriver() {
	    try {
	        Class.forName("com.mysql.cj.jdbc.Driver");
	    } catch (ClassNotFoundException e) {
	        e.printStackTrace();
	    }
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String name = request.getParameter("name");
        String email = request.getParameter("email");
        int age = Integer.parseInt(request.getParameter("age"));
        
        initDBDriver();

        try (Connection connection = DriverManager.getConnection(DB_URL, DB_USER, DB_PASSWORD);
             PreparedStatement statement = connection.prepareStatement("INSERT INTO users (name, email, age) VALUES (?, ?, ?)")) {

            statement.setString(1, name);
            statement.setString(2, email);
            statement.setInt(3, age);

            int rowsInserted = statement.executeUpdate();
            response.getWriter().println(rowsInserted > 0 ? "User registered successfully!" : "Error registering user.");

        } catch (SQLException e) {
            e.printStackTrace();
            response.getWriter().println("Database error: " + e.getMessage());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();

        out.println("<html><head><title>User List</title></head><body>");
        out.println("<h2>Registered Users</h2>");
        out.println("<table border='1'><tr><th>ID</th><th>Name</th><th>Email</th><th>Age</th></tr>");

        try (Connection connection = DriverManager.getConnection(DB_URL, DB_USER, DB_PASSWORD);
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM users");
             ResultSet resultSet = statement.executeQuery()) {

            while (resultSet.next()) {
            	int id = resultSet.getInt("id");
            	String name = resultSet.getString("name");
            	String email = resultSet.getString("email");
            	int age = resultSet.getInt("age");
            	
            	User user = new User(id, name, email, age);
            	this.userList.add(user);
 
            	out.println("<tr>");
            	out.println("<td>" + user.getId() + "</td>");
            	out.println("<td>" + user.getName() + "</td>");
            	out.println("<td>" + user.getEmail() + "</td>");
            	out.println("<td>" + user.getAge() + "</td>");
            	out.println("</tr>");   
            }

        } catch (SQLException e) {
            e.printStackTrace();
            out.println("<p>Database error: " + e.getMessage() + "</p>");
        }

        out.println("</table>");
        out.println("</body></html>");
    }
    

}
